'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub RechnungJeKategorieFestlegen()
    ReJeKategorie = False
    'nur wenn Kontrllkstchen aktiviert und angehakt ist, dann:
    If Me.Haken_ReJeKategorie.Enabled = True Then
        If Me.Haken_ReJeKategorie.Value = True Then
            ReJeKategorie = True
        End If
    End If
End Sub

Private Sub Button_ReNr_Festlegen_Click()
On Error GoTo Err_Button_ReNr_Festlegen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
              
              
    'Eigentliches Formular ffnen
    stDocName = "Rechnungsnummern"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
        
Exit_Button_ReNr_Festlegen_Click:
    Exit Sub

Err_Button_ReNr_Festlegen_Click:
    MsgBox err.Description
    Resume Exit_Button_ReNr_Festlegen_Click

End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Activate()
    Dim Text As String
    
    
    'Bei Kalkulationslauf dessen Ende Mitteilen
    If ReLaufArt = 5 Then
        MsgBox "Kalkulation beendet.", vbOKOnly + vbInformation, "Fertig"
        Exit Sub
    End If
    
    
    'Wenn Fenster offen und nach Testlaufvorschau wieder aktiv wird,
    'nachfragen, ob der Echtlauf durchgefhrt werden soll
    If TestlaufAnsichtGeschlossen = False Then Exit Sub
        'Variable zurcksetzen
        TestlaufAnsichtGeschlossen = False
        'Bildschirmaufbau "bereinigen"
        DoCmd.OpenForm "BlankoFormular"
        DoCmd.Close acForm, "BlankoFormular", acSaveYes
        'Benutzer fragen, ob Echtlauf durchgefhrt werden soll
        Text = "Wenn der Testlauf in Ordnung ist, knnen Sie nun die Rechnungen im Echtlauf erstellen."
            Text = Text & vbNewLine & vbNewLine & "Mchten Sie die Rechnungen jetzt erstellen?"
        If MsgBox(Text, vbYesNo + vbDefaultButton2 + vbExclamation, "Rechnungen erstellen...") = vbNo Then Exit Sub
        'Echtlauf anstoen
        Call RechnungJeKategorieFestlegen
        ReEchtlauf = True
        Rechnungslauf
    
End Sub


Private Sub Form_Load()
    On Error Resume Next
    
    'Verhinderung der Meldung, dass der Kalkulationslauf beendet sei, wenn beim
    'letzten Mal der Kalkulationslauf gewhlt war
    ReLaufArt = 0
    
    'Grundstzliche Einstellung, das von hier KEINE Outlook-Uebernahme erfolgt
    KalkulationAusOutlookUebernahme = False
    
    
    DoCmd.Close acForm, "Kategorien", acSaveYes
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Monate und Jahr einstellen ---------------------------
    Me.Monat_von.DefaultValue = 1
    ' Me.Monat_von.DefaultValue = Month(Now()) - 1
    Me.Monat_bis.DefaultValue = Month(Now()) - 1
    Me.Jahresauswahl.DefaultValue = Year(Now())
    'gesperrte Jahre beachten
    If Me.Jahresauswahl < Me.NichtVorJahr Then Me.Jahresauswahl.DefaultValue = Me.NichtVorJahr
    If Month(Now()) = 1 Then
        Me.Monat_von.DefaultValue = 1
        Me.Monat_bis.DefaultValue = 12
        Me.Jahresauswahl.DefaultValue = Year(Now()) - 1
        'gesperrte Jahren beachten
        If Me.Jahresauswahl < Me.NichtVorJahr Then
            Me.Monat_von.DefaultValue = 1
            Me.Monat_bis.DefaultValue = 1
            Me.Jahresauswahl.DefaultValue = Me.NichtVorJahr
        End If
    End If
    'Rechnungsdatum mit aktuellem Tag vorbelegen
    Me.ReDatum = Date
    'Variablen initialisieren
    TestlaufAnsichtGeschlossen = False
    ReEchtlauf = False
    ReUngedrucktAlle = False
    
    Me.Haken_ReJeKategorie.Value = False
End Sub

Private Sub Jahresauswahl_AfterUpdate()
    'gesperrte Jahren beachten
    If Me.Jahresauswahl < Me.NichtVorJahr Then
        Me.Jahresauswahl.DefaultValue = Me.NichtVorJahr
    End If
End Sub

Private Sub Jahresauswahl_BeforeUpdate(Cancel As Integer)
    'gesperrte Jahren beachten
    If Me.Jahresauswahl < Me.NichtVorJahr Then
        MsgBox "Gem Ihren Einstellungen drfen keine Termine der Jahre vor " & Me.NichtVorJahr.Value & " berechnet/gendert werden.", vbCritical + vbOKOnly, "Jahr gesperrt"
    End If
End Sub

Private Sub Kategorien_alle_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Haken_ReJeKategorie.Enabled = True
End Sub

Private Sub Kategorien_direkt_GotFocus()
    Me.Kategorieauswahl.DefaultValue = 1
    Me.Haken_ReJeKategorie.Enabled = False
End Sub

Private Sub Kategorien_direkt_LostFocus()
    If IsNull(Me.Kategorien_direkt.Value) Then
        Me.Kategorieauswahl.DefaultValue = 0
        Me.Haken_ReJeKategorie.Enabled = True
    End If
End Sub

Private Sub Kategorien_nur_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kategorien_direkt.SetFocus
    Me.Haken_ReJeKategorie.Enabled = False
End Sub

Private Sub Kopieanzahl_LostFocus()
    If IsNull(Me.Kopieanzahl.Value) Then Me.Kopieanzahl.Value = 0
End Sub

Private Sub Kunden_direkt_GotFocus()
    Me.Kundenauswahl.DefaultValue = 1
End Sub

Private Sub Kunden_direkt_LostFocus()
    If IsNull(Me.Kunden_direkt.Value) Then Me.Kundenauswahl.DefaultValue = 0
End Sub

Private Sub Kunden_nur_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kunden_direkt.SetFocus
End Sub

Private Sub Monat_bis_AfterUpdate()
    Monat_von_AfterUpdate
End Sub

Private Sub Monat_von_AfterUpdate()
    'wenn Von > Bis, dann Felder tauschen
    If Me.Monat_von.Value > Me.Monat_bis.Value Then
        ReMonatVon = Me.Monat_von.Value
        'Me.Monat_von.Value = Me.Monat_bis.Value
        Me.Monat_bis.Value = ReMonatVon
    End If
End Sub

Private Sub Rechnungslauf_Art_AfterUpdate()
    Me.Testlauf_Haken.Enabled = True
    Me.Testlauf_Haken.Value = True                  'Testlauf zunchst immer aktivieren
    
    Testlauf_Haken_AfterUpdate
    
End Sub


Private Sub Rechnungslauf_Art_Enter()
    'Hintergrundfarbe auf wei setzen, weil sonst die Liste beim Aufklappen farbig ist
    Me.Rechnungslauf_Art.BackColor = 16777215
End Sub

Private Sub Rechnungslauf_Art_LostFocus()
    'Hintergrundfarbe entsprechend der Re-Laufart festlegen
    If Me.Rechnungslauf_Art.Value = 1 Then          '1 = normaler Rechnungslauf
        Me.Rechnungslauf_Art.BackColor = 8454016        'grn
    End If
    If (Me.Rechnungslauf_Art.Value = 2) Or (Me.Rechnungslauf_Art.Value = 5) Then     '2/5 = nur generieren/speichern ODER Kalkulation
        Me.Rechnungslauf_Art.BackColor = 8454143        'gelb
    End If
    If Me.Rechnungslauf_Art.Value = 3 Then          '3 = nur drucken
        Me.Rechnungslauf_Art.BackColor = 16777088       'blau
    End If
    If Me.Rechnungslauf_Art.Value = 4 Then          '4 = Generalrckrechnung!
        Me.Rechnungslauf_Art.BackColor = 255            'rot
    End If
End Sub

Private Sub Rechnungslauf_Drucken_Click()
    ReKopieAnzahl = Forms!Rechnungslaufparameter.Kopieanzahl.Value
    ReKopieZeitpunkt = Forms!Rechnungslaufparameter.Kopie_Zeitpunkt.Value
    ReLaufArt = Forms!Rechnungslaufparameter.Rechnungslauf_Art.Value
    DoCmd.OpenForm "Rechnungslaeufe_Auswahl"
End Sub

Private Sub Rechnungslauf_Generieren_Click()
    Call RechnungJeKategorieFestlegen
    Rechnungslauf
End Sub

Private Sub Rechnungslauf_Normal_Click()
    Call RechnungJeKategorieFestlegen
    Rechnungslauf
End Sub

Private Sub Rechnungslauf_Testlauf_Click()
    Call RechnungJeKategorieFestlegen
    ReLaufArt = Forms!Rechnungslaufparameter.Rechnungslauf_Art.Value
    If ReLaufArt = 4 Then
        DoCmd.OpenForm "Generalrueckrechnung_Hinweis"
    Else
        Rechnungslauf
    End If
End Sub

Private Sub Testlauf_Haken_AfterUpdate()

    'Schaltflchen verbergen
    Me.Rechnungslauf_Normal.Visible = False         '1
    Me.Rechnungslauf_Generieren.Visible = False     '2
    Me.Rechnungslauf_Drucken.Visible = False        '3
    Me.Rechnungslauf_General.Visible = False        '4
    'alle Eingabefelder aktivieren
    Me.ReDatum.Enabled = True
    Me.Monat_von.Enabled = True
    Me.Monat_bis.Enabled = True
    Me.Jahresauswahl.Enabled = True
    Me.Kundenauswahl.Enabled = True
    Me.Kunden_direkt.Enabled = True
    Me.Kategorieauswahl.Enabled = True
    Me.Kategorien_direkt.Enabled = True
    Me.Kopieanzahl.Enabled = True
    Me.Kopie_am_Ende.Enabled = True
    Me.Kopie_nach_Original.Enabled = True
    Me.Button_ReNr_Festlegen.Enabled = True
    'nur eine Schaltflche sichtbar machen
    If Me.Rechnungslauf_Art.Value = 1 Then          '1 = normaler Rechnungslauf
        Me.Rechnungslauf_Art.BackColor = 8454016
        Me.Rechnungslauf_Normal.Visible = True
    End If
    If Me.Rechnungslauf_Art.Value = 2 Then          '2 = nur generieren/speichern
        Me.Rechnungslauf_Art.BackColor = 8454143
        Me.Rechnungslauf_Generieren.Visible = True
        'bei nur Generieren/Speichern machen Kopien keinen Sinn, oder...?
        Me.Kopieanzahl.Enabled = False
        Me.Kopie_am_Ende.Enabled = False
        Me.Kopie_nach_Original.Enabled = False
    End If
    If Me.Rechnungslauf_Art.Value = 3 Then          '3 = nur drucken
        Me.Rechnungslauf_Art.BackColor = 16777088
        Me.Rechnungslauf_Drucken.Visible = True
        Me.Rechnungslauf_Drucken.Enabled = True
        Me.Button_ReNr_Festlegen.Enabled = False
        'bei Wiederholungsdruck machen diese Eingaben keinen Sinn, oder...?
        Me.ReDatum.Enabled = False
        Me.Monat_von.Enabled = False
        Me.Monat_bis.Enabled = False
        Me.Jahresauswahl.Enabled = False
        Me.Kundenauswahl.Enabled = False
        Me.Kunden_direkt.Enabled = False
        Me.Kategorieauswahl.Enabled = False
        Me.Kategorien_direkt.Enabled = False
        'bei Wiederholungsdruck macht ein Testlauf keinen Sinn, oder...?
        Me.Rechnungslauf_Testlauf.Enabled = False
        Me.Testlauf_Haken.Value = False
        Me.Testlauf_Haken.Enabled = False
    End If
    If Me.Rechnungslauf_Art.Value = 4 Then          '4 = Generalrckrechnung!
        Me.Rechnungslauf_Art.BackColor = 255
        Me.Rechnungslauf_General.Visible = True
        Me.Testlauf_Haken.Value = True
        Me.Testlauf_Haken.Enabled = False
    End If
    If Me.Rechnungslauf_Art.Value = 5 Then          '5 = Kalkulationslauf
        Me.Rechnungslauf_Art.BackColor = 8454143
        Me.Rechnungslauf_General.Enabled = False
        Me.Testlauf_Haken.Value = True
        Me.Testlauf_Haken.Enabled = False
        Me.ReDatum.Enabled = False
        Me.Button_ReNr_Festlegen.Enabled = False
        'beim Kalkulationslauf machen Kopien keinen Sinn, oder...?
        Me.Kopieanzahl.Enabled = False
        Me.Kopie_am_Ende.Enabled = False
        Me.Kopie_nach_Original.Enabled = False
    End If
    'nur eine Schaltflche aktivieren
    If Me.Testlauf_Haken.Value = 0 Then
        If Me.Rechnungslauf_Art.Value = 1 Then Me.Rechnungslauf_Normal.Enabled = True
        If Me.Rechnungslauf_Art.Value = 2 Then Me.Rechnungslauf_Generieren.Enabled = True
        'If Me.Rechnungslauf_Art.Value = 3 Then Me.Rechnungslauf_Drucken.Enabled = True
        If Me.Rechnungslauf_Art.Value = 4 Then Me.Rechnungslauf_General.Enabled = True
        Me.Rechnungslauf_Testlauf.Enabled = False
    Else
        If Me.Rechnungslauf_Art.Value = 1 Then Me.Rechnungslauf_Normal.Enabled = False
        If Me.Rechnungslauf_Art.Value = 2 Then Me.Rechnungslauf_Generieren.Enabled = False
        'If Me.Rechnungslauf_Art.Value = 3 Then Me.Rechnungslauf_Drucken.Enabled = False
        If Me.Rechnungslauf_Art.Value = 4 Then Me.Rechnungslauf_General.Enabled = False
        Me.Rechnungslauf_Testlauf.Enabled = True
    End If


    If Me.Rechnungslauf_Art.Value = 4 Then
        If Me.Testlauf_Haken.Value = 0 Then
            Me.Rechnungslauf_Testlauf.Enabled = False
            Me.Rechnungslauf_General.Enabled = True
        Else
            Me.Rechnungslauf_Testlauf.Enabled = True
            Me.Rechnungslauf_General.Enabled = False
        End If
    End If
    
End Sub
